

class PolicyStruct(object):
    def __init__(self, policy, config):
        self.policy = policy
        self.config = config


class LazyDict(dict):
    """
    Takes a dictionary of lambdas, and executes the lambda on get for the item.
    The purpose of of this is to be able to load dependencies only as we need them, so users don't have to install
    things they'll never need.
    """
    def __init__(self, dict):
        super().__init__(dict)
        self._dict = dict

    def __getitem__(self, item):
        return self._dict[item]()



def load_impala():
    from continual_rl.policies.impala.impala_policy import ImpalaPolicy
    from continual_rl.policies.impala.impala_policy_config import ImpalaPolicyConfig
    return PolicyStruct(ImpalaPolicy, ImpalaPolicyConfig)


def load_clear():
    from continual_rl.policies.clear.clear_policy import ClearPolicy
    from continual_rl.policies.clear.clear_policy_config import ClearPolicyConfig
    return PolicyStruct(ClearPolicy, ClearPolicyConfig)




def load_DSNet_ensemble():
    from continual_rl.policies.DSNet.DSNet_policy import DSNetPolicy
    from continual_rl.policies.DSNet.DSNet_policy_config import SanePolicyConfig
    return PolicyStruct(DSNetPolicy, SanePolicyConfig)


def get_available_policies():
    """
    The registry of policies that are available for ease of use. To create your own, duplicate prototype_policy's
    folder, populate it (reference policy_base.py as necessary), and add it here.
    """
    policies = LazyDict({
                         "DSNet": load_DSNet_ensemble})
    return policies
